% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_transfer.R
\name{wf_transfer}
\alias{wf_transfer}
\title{ECMWF data transfer function}
\usage{
wf_transfer(
  url,
  user,
  service = "webapi",
  path = tempdir(),
  filename = tempfile("ecmwfr_"),
  verbose = TRUE
)
}
\arguments{
\item{url}{url to query}

\item{user}{user (email address) used to sign up for the ECMWF data service,
used to retrieve the token set by \code{\link[ecmwfr]{wf_set_key}}.}

\item{service}{which service to use, one of \code{webapi}, \code{cds}
or \code{ads} (default = webapi)}

\item{path}{path were to store the downloaded data}

\item{filename}{filename to use for the downloaded data}

\item{verbose}{show feedback on data transfers}
}
\value{
a netCDF of data on disk as specified by a
\code{\link[ecmwfr]{wf_request}}
}
\description{
Returns the contents of the requested url as a NetCDF file downloaded
to disk or the current status of the requested transfer.
}
\examples{

\dontrun{
# set key
wf_set_key(user = "test@mail.com", key = "123")

# request data and grab url and try a transfer
r <- wf_request(request, "test@email.com", transfer = FALSE)

# check transfer, will download if available
wf_transfer(r$href, "test@email.com")
}
}
\seealso{
\code{\link[ecmwfr]{wf_set_key}}
\code{\link[ecmwfr]{wf_request}}
}
\author{
Koen Hufkens
}
