% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seaweed.R
\docType{data}
\name{seaweed}
\alias{seaweed}
\title{Habitat Configuration data from seaweed experiment}
\format{
A dataframe containing:\describe{
\item{Size}{A character vector describing size of experimental plots as "SMALL" or "LARGE"}
\item{Dist}{Distance of isolation -- 0, 2 or 10 metres from other algal beds}
\item{Time}{Sampling time - either 5 or 10 weeks from the start of the experiment.}
\item{Rep}{The replicate number (1 to 5).}
\item{Wmass}{Wet mass of the algal bed for that plot.}
\item{Total}{Total invertebrate density in the plot, calculated as nuber of individuals divided by \code{Wmass}.}
}
Other variables in the dataset give invertebrate counts separately for different taxa.
}
\usage{
data(seaweed)
}
\description{
Data from a study of habitat configuration, specifically, does density of invertebrate epifauna on seaweed
vary across sites with different levels of isolation from each other.
}
\examples{
data(seaweed)
boxplot(Total~Dist, data=seaweed)
}
\references{
Roberts, D. A. & Poore, A. G. (2006). Habitat configuration affects colonisation of
epifauna in a marine algal bed. Biological Conservation \bold{127}, 18-26.
}
\keyword{datasets}
