% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.manyglm.R
\name{simulate.manyglm}
\alias{simulate.manyglm}
\title{Simulate from manyglm objects}
\usage{
\method{simulate}{manyglm}(object, nsim = 1, seed = NULL, newdata = object$data, ...)
}
\arguments{
\item{object}{a \code{manyglm} object from the \code{mvabund} package.}

\item{nsim}{number of simulated datasets to generate.}

\item{seed}{a seed for random number generation (defaults to NULL)}

\item{newdata}{a new dataset with predictors to simulate new values for. Defaults to data model was fitted to.}

\item{...}{additional optional arguments.}
}
\value{
Simulates a data frame of new values for responses. If multiple datasets are requested, these are
stacked one under the other (see \code{example(simulate.cord)}.
}
\description{
Simulates new responses for a manyglm object.
}
\details{
Returns a data frame containing the response and predictors. This function just calls \code{simulate.cord} 
from the \code{ecoCopula} package, on a \code{cord} object constructed under default settings -- that is, 
it fits a copula latent variable model with two latent variables, then uses this to simulate new data.
}
\seealso{
\code{\link[mvabund]{manyglm}}, \code{\link[ecoCopula]{cord}}, \code{\link[ecoCopula]{simulate.cord}}
}
\author{
David Warton <david.warton@unsw.edu.au>
}
