% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_processing_time.R
\name{filter_processing_time}
\alias{filter_processing_time}
\alias{filter_processing_time.eventlog}
\alias{filter_processing_time.grouped_eventlog}
\alias{ifilter_processing_time}
\title{Filter: Processing Time}
\usage{
filter_processing_time(eventlog, interval, percentage, reverse, units, ...)

\method{filter_processing_time}{eventlog}(
  eventlog,
  interval = NULL,
  percentage = NULL,
  reverse = FALSE,
  units = c("days", "hours", "mins", "secs", "weeks"),
  ...
)

\method{filter_processing_time}{grouped_eventlog}(
  eventlog,
  interval = NULL,
  percentage = NULL,
  reverse = FALSE,
  units = c("days", "hours", "mins", "secs", "weeks"),
  ...
)

ifilter_processing_time(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{interval}{An duration interval (numeric vector of length 2) to be used for absolute. Half open interval can be created using NA.}

\item{percentage}{A percentage p to be used for relative filtering.}

\item{reverse}{Logical, indicating whether the selection should be reversed.}

\item{units}{The time unit used for defining filter intervals.}

\item{...}{Deprecated arguments.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters cases based on their processing time.
}
\details{
This filter can be used by using an interval or by using a percentage.
The percentage will always start with the shortest cases first and stop
including cases when the specified percentile is reached. On the other hand, an absolute
interval can be defined instead to filter cases which have a processing time in this interval. The time units
in which this interval is defined can be submitted with the units argument.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter event log

\item \code{grouped_eventlog}: Filter grouped event log
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
