% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWordHistogram.R
\name{getWordHistogram}
\alias{getWordHistogram}
\title{Creates histogram of most frequent words in EDGAR filing.}
\usage{
getWordHistogram(word.frq, words.list)
}
\arguments{
\item{word.frq}{Word frequency dataframe created using 
\link[edgar]{getWordfrquency} function.}

\item{words.list}{Word list as a sentiment dictionary.}
}
\value{
Function creates histogram.
}
\description{
\code{getWordHistogram} creates histogram of most frequent words in filing.
}
\details{
getWordHistogram function takes words frequency dataframe as an input from 
\link[edgar]{getWordfrquency} function. It compares these words 
with input dictionary and generates histogram of 15 most frequent matched words 
with their frequencies.
}
\examples{
\dontrun{

words.list <- scan(system.file('data/negwords.txt', package = 'edgar'), what='character')
## User can apply any desired user defined dictionary other than 
## default dictionaries from this package.

getWordHistogram(word.frq, words.list)
}

}
