% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxc.R
\docType{data}
\name{hcpcs_rxc}
\alias{hcpcs_rxc}
\title{HCPCS to Rx Condition Crosswalk - Table 10b}
\format{An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with
43 rows and 3 columns
\describe{
\item{rxc}{Rx condition number without leading zeroes}
\item{desc}{Rx condition description}
\item{ndc}{HCPCS code that maps to \code{rxc}}
}}
\source{
Most recent DIY entry at:
\url{https://www.cms.gov/cciio/Resources/Regulations-and-Guidance/index} \cr
Data import and cleaning at:
\url{https://github.com/ArctiCondor/edgedata/tree/master/data-raw}
}
\usage{
hcpcs_rxc
}
\description{
A dataset containing the HCPCS to Rx condition mappings.
}
\details{
HCPCS codes create a system for identifying drugs given in a medical setting. But since
there are so many drugs, and they very specific, the HHS-HCC model groups
similar drugs into broader Rx condition categories.
}
\seealso{
Other crosswalks: 
\code{\link{icd_cc}},
\code{\link{ndc_rxc}}

Other RXC tables: 
\code{\link{adult_rxc_hcc_inter}},
\code{\link{adult_rxc}},
\code{\link{ndc_rxc}},
\code{\link{rxc_hier}}
}
\concept{RXC tables}
\concept{crosswalks}
\keyword{datasets}
