% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatrixOperators.R
\name{psd2edm}
\alias{psd2edm}
\title{Linear Matrix Operator}
\usage{
psd2edm(S, V = NULL)
}
\arguments{
\item{S}{A symmetric, positive semi-definite matrix}

\item{V}{A projection matrix satisfying V'1 = 0 and VV' = I}
}
\value{
D A Euclidean Distance Matrix.
}
\description{
\code{psd2edm} Transform a positive semi-definite matrix to a Euclidean Distance Matrix
}
\details{
The psd2edm function performs the inverse operation of the edm2psd function, 
taking a matrix in \eqn{S_{n-1}^{+}} and transforming it to a matrix in \eqn{D_{n}^{-}}.

\deqn{psd2edm(S_{n-1}^{+}) = D_{n}^{-}}

Therefore, psd2edm on \eqn{S_{n-1}^{+}} is the inverse operator of  edm2psd on \eqn{D_{n}^{-}}. 

For a symmetric positive semi-definite matrix S, psd2edm(S) will be in \eqn{D_{n}^{-}}.
}
\examples{

XY <- cbind(runif(100,0,1),runif(100,0,1))
S <- edm2psd(as.matrix(dist(XY)))
D <- psd2edm(S)

}
\seealso{
\code{\link{gram2edm}} \code{\link{edm2psd}}
}
