#' plot the fitted bimodal normal distribution for CpGs distances distribution
#' @export
#' @param mixmdl object generated by \code{myDiff.to.mixmdl}
#' @param subtitle subtitle for the plot
#' @param cex.sub subtitle font size
#' @seealso \code{\link{myDiff.to.mixmdl}}
# @examples
# library(edmr)
# library(mixtools)
# data(edmr)
# 
# myMixmdl=myDiff.to.mixmdl(myDiff)
# plotMdl1(myMixmdl, subtitle="example", cex.sub=1.2)

plotMdl1=function(mixmdl, subtitle="", cex.sub=1){
  xlim=c(0,ceiling(max(mixmdl$x)))
  if(mixmdl$lambda[1] < mixmdl$lambda[2]) { 
    mixmdl$mu=mixmdl$mu[2:1]
    mixmdl$sigma=mixmdl$sigma[2:1]
    mixmdl$lambda=mixmdl$lambda[2:1]
  }
  plot(mixmdl,which=2, xlim=xlim,  breaks=seq(0,max(xlim),by=1))
  lines(density(mixmdl$x, n=50), lty=2, lwd=2)
  legend("topright", c("First model","Second model","data density"), lty=c(1,1,2), pch="", col=c("red","green","black"))
  mtext(subtitle, cex=cex.sub)
}
