% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.R
\name{edwards_coefs}
\alias{edwards_coefs}
\alias{edwards_data}
\alias{fit_edwards}
\title{Coagulation coefficients}
\usage{
edwards_coefs(type)

edwards_data(type)

fit_edwards(type)
}
\arguments{
\item{type}{One of "Low DOC", "Fe", "Al", "General-Fe", "General-Al", or "empty".}
}
\value{
A named vector of empirical coefficients to be used in
\code{\link[=coagulate]{coagulate()}}.
}
\description{
These are coefficients intended for general use. Use
\code{\link[=fit_edwards_optim]{fit_edwards_optim()}} to optimise these coefficients
for a specific source water.
}
\examples{
edwards_coefs("Low DOC")

}
\references{
Edwards, M. 1997. Predicting DOC removal during enhanced coagulation.
Journal - American Water Works Association, 89: 78–89.
https://doi.org/10.1002/j.1551-8833.1997.tb08229.x
}
