% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amenable.R
\name{isIdentified}
\alias{isIdentified}
\title{Check if a total causal effect is identified}
\usage{
isIdentified(amat, x, y, type = "pdag")
}
\arguments{
\item{amat}{adjacency matrix. See \code{\link{estimateEffect}}
for its coding.}

\item{x}{(integer) positions of treatment variables in the adjacency matrix}

\item{y}{(integer) positions of outcome variables in the adjacency matrix}

\item{type}{string specifying the type of graph of \code{amat}. It can be
DAG (\code{type='dag'}) or MPDAG/CPDAG (\code{type='pdag'}).}
}
\value{
\code{TRUE} if identified, \code{FALSE} if not.
}
\description{
The total causal effect from x to y is identified if and only if there is
no possibly causal path from x to y that starts with an undirected edge.
}
\examples{
data("ex1")
# identified
isIdentified(ex1$amat.cpdag, c(3, 5), 7)
# not identified
isIdentified(ex1$amat.cpdag, 3, 7)
isIdentified(ex1$amat.cpdag, c(3, 5), 10)
}
\references{
Emilija Perkovic. Identifying causal effects in maximally oriented
partially directed acyclic graphs.
In \emph{Uncertainty in Artificial Intelligence (UAI)}, 2020.
}
\seealso{
\code{\link{estimateEffect}}
}
