% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{eia_data}
\alias{eia_data}
\title{EIA data}
\usage{
eia_data(
  dir,
  data = NULL,
  facets = NULL,
  freq = NULL,
  start = NULL,
  end = NULL,
  sort = NULL,
  length = NULL,
  offset = NULL,
  tidy = TRUE,
  cache = TRUE,
  key = eia_get_key()
)
}
\arguments{
\item{dir}{character, directory path.}

\item{data}{character or \code{NULL}, see details.}

\item{facets}{character list or \code{NULL}, see details.}

\item{freq}{character or \code{NULL}, if char, then one of: "yearly", "monthly",
"daily", "hourly".}

\item{start, end}{character or \code{NULL}, must match format of default or supplied
\code{freq}; i.e. if \code{freq = "yearly"}, then format of \code{start} must be \code{YYYY}.}

\item{sort}{named list of two.
\itemize{
\item \code{cols}: list column names on which to sort.
\item \code{order}: \code{"asc"} or \code{"desc"} for ascending or descending, respectively.
}}

\item{length}{numeric or \code{NULL}, number of rows to return.}

\item{offset}{numeric or \code{NULL}, number of rows to skip before return.}

\item{tidy}{logical or \code{NULL}, return a tidier result. See details.}

\item{cache}{logical, cache result for duration of R session using memoization.
See details.}

\item{key}{API key: character if set explicitly; not needed if key is set
globally. See \code{eia_set_key()}.}
}
\value{
data frame
}
\description{
Obtain data from the EIA.
}
\details{
By default, \code{data}, \code{facets}, and \code{freq} are set to \code{NULL}. To obtain valid
input values for each of these arguments, one must use the specific ID labels
as provided by \code{eia_metadata()}.

By default, additional processing is done to return a list containing tibble data frames.
Set \code{tidy = FALSE} to return only the initial list result of \code{jsonlite::fromJSON}.
Set \code{tidy = NA} to return the original JSON as a character string.

Set to \code{cache = FALSE} to force a new API call for updated data.
Using \code{FALSE} always makes a new API call and returns the result from the server.
\code{TRUE} uses memoization on a per R session basis, caching the result of the
function call in memory for the duration of the R session.
You can reset the entire cache by calling \code{eia_clear_cache()}.
}
\examples{
\dontrun{
eia_data(
  dir = "electricity/retail-sales",
  data = "price",
  facets = list(sectorid = c("COM", "RES"), stateid = "OH")
)
}
}
