% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.r
\name{confint.eicm}
\alias{confint.eicm}
\title{Confidence intervals for EICM parameters}
\usage{
\method{confint}{eicm}(
  object,
  parm,
  level = 0.99,
  step = 0.3,
  ncores = parallel::detectCores(),
  ...
)
}
\arguments{
\item{object}{the fitted EICM model.}

\item{parm}{currently unused.}

\item{level}{the confidence level required.}

\item{step}{the step increments/decrements at which to compute the likelihood profile points.}

\item{ncores}{the number of CPU cores to use when computing profiles for all parameters.}

\item{...}{additional argument(s) for methods}
}
\value{
The same model object with a new \code{confint} component.
}
\description{
Computes the profile (penalized) likelihood confidence intervals for all estimated parameters in a EICM model.
If the likelihood profiles are not computed yet, they will be computed first.
}
\examples{
\donttest{
# load the included parameterized model
data(truemodel)

# realize the model
occurrences <- predict(truemodel, nrepetitions=1)

# fit the model without species interactions
fitted <- eicm(occurrences, n.latent=2, mask.sp=0, do.selection=FALSE)$fitted.model

# compute confidence intervals for all parameters
# this updates the fitted model with the confints
fitted <- confint(fitted, ncores=2)

# plot the confidence intervals
plot(fitted, type="confint")
}
}
