% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_brams_spm.R
\name{to_brams_spm}
\alias{to_brams_spm}
\title{Inputs for BRAMS-SPM}
\usage{
to_brams_spm(sdf, epsg = 4326)
}
\arguments{
\item{sdf}{Grid emissions, which can be a SpatialPolygonsDataFrame or polygon
grid class sf' including the hourly emissions in mol/h for 24 hours. The
object can also be a list of objects SpatialPolygonsDataFrame or Spatial
Features polygon grid class 'sf'.}

\item{epsg}{Coordinate reference system, e.g: "4326". Used to transform the
coordinates of the output.}
}
\value{
data-frame of daily gridded emissions, lat, long and a message with
function.
}
\description{
Create inputs for BRAMS-SPM. The inputs consist of a data-frame
or a list of data-frames with daily emissions (mol/day), lat, long. Also,
including a functions describing the hourly profile.
}
\note{
When the input is class 'Spatial', they are converted to 'sf'. If the
input is a data-frame, the output is a data-frame. If the input is a list,
the output is a list.
}
\examples{
\dontrun{
data(gCO)
df1 <- to_brams_spm(sdf = gCO,
                    epsg = 4326)
head(df1)
df2 <- to_brams_spm(sdf = list(co = gCO, pm = gCO),
                    epsg = 4326)
lapply(df2, head)
}
}
\references{
SPM BRAMS: FREITAS, E. MARTINS, L.,  SILVA, P. and ANDRADE, M.
A simple photochemical module implemented in rams for tropospheric ozone
concentration forecast in the metropolitan area of são paulo, brazil:
Coupling and validation. Atmospheric Environment, Elsevier, n. 39, p.
6352–6361, 2005.
}
\author{
Sergio Ibarra and Edmilson Freitas
}
