% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_elastic_regression.R
\name{fit_elastic_regression}
\alias{fit_elastic_regression}
\title{Compute a elastic mean for a collection of curves}
\usage{
fit_elastic_regression(
  formula,
  data_curves,
  x_data,
  knots = seq(0, 1, 0.2),
  type = "smooth",
  closed = FALSE,
  max_iter = 10,
  eps = 0.001
)
}
\arguments{
\item{formula}{an object of class "formula" of the form data_curves ~ ...".}

\item{data_curves}{list of \code{data.frame}s with observed points in each row. Each
variable is one coordinate direction. If there is a variable \code{t},
it is treated as the time parametrization, not as an additional coordinate.}

\item{x_data}{a \code{data.frame} with covariates.}

\item{knots}{set of knots for the parameter curves of the regression model}

\item{type}{if "smooth" linear srv-splines are used which results in a differentiable mean curve
if "polygon" the mean will be piecewise linear.}

\item{closed}{\code{TRUE} if the curves should be treated as closed.}

\item{max_iter}{maximal number of iterations}

\item{eps}{the algorithm stops if L2 norm of coefficients changes less}
}
\value{
an object of class \code{elastic_reg_model}, which is a \code{list}
with entries
  \item{type}{"smooth" if linear srv-splines or
  "polygon" if constant srv-splines were used}
  \item{coefs}{spline coeffiecients}
  \item{knots}{spline knots}
  \item{data_curves}{list of \code{data.frame}s with observed points in each row.
  First variable \code{t} gives the initial parametrization, second variable \code{t_optim}
  the optimal parametrization when the curve is aligned to the model prediction.}
  \item{closed}{\code{TRUE} if the regression model fitted closed curves.}
}
\description{
Computes a Fréchet mean for the curves stored in \code{data_curves} with respect
to the elastic distance. Constructor function for class \code{elastic_reg_model}.
}
\examples{
curve <- function(x_1, x_2, t){
  rbind(2*t*cos(6*t) - x_1*t , x_2*t*sin(6*t))
}
set.seed(18)
x_data <- data.frame(x_1 = runif(10,-1,1), x_2 = runif(10,-1,1))
data_curves <- apply(x_data, 1, function(x){
  m <- sample(10:15, 1)
  delta <- abs(rnorm(m, mean = 1, sd = 0.05))
  t <- cumsum(delta)/sum(delta)
  data.frame(t(curve((x[1] + 1), (x[2] + 2), t))
   + 0.07*t*matrix(cumsum(rnorm(2*length(delta))), ncol = 2))
})
reg_model <- fit_elastic_regression(data_curves ~ x_1 + x_2,
                                    data_curves = data_curves, x_data = x_data)
plot(reg_model)
}
