% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPQ.R
\name{MPQ}
\alias{MPQ}
\title{Test for elliptical symmetry by Manzotti et al.}
\usage{
MPQ(X, epsilon = 0.05)
}
\arguments{
\item{X}{A numeric matrix.}

\item{epsilon}{A value which indicates the percentage of points close to origin which will not be used in the calculation. Default is set to 0.05.}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{\code{statistic}}{The value of the test statistic.}
\item{\code{pvalue}}{The p-value of the test.}
\item{\code{alternative}}{A character string describing the alternative hypothesis.}
\item{\code{method}}{A character string indicating what type of test was performed.}
}
\description{
Test for elliptical symmetry based on the averages of spherical harmonics.
}
\section{Background}{

Test for elliptical symmetry based on spherical harmonics of degrees 3 and 4. The test statistic involves the averages of spherical harmonics
over the projections of the scale residuals on the unit sphere. This test requires moments of order 4, it has a simple asymptotic distribution
but does not have asymptotic power 100\% against all alternatives.
}

\examples{

## sepal width and length of the versicolor subset of the Iris data
X = datasets::iris[51:100, 1:2]

MPQ(X)

}
\references{
Manzotti, A., Perez, Francisco J., & Quiroz, Adolfo J. (2002). A statistic for testing the null hypothesis of elliptical symmetry. \emph{Journal of Multivariate Analysis}, \bold{81}(2), 274-285.
}
