% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{get_avg_activity_diff_based_on_synergy_set_cmp}
\alias{get_avg_activity_diff_based_on_synergy_set_cmp}
\title{Get the average activity difference based on the comparison of two synergy sets}
\usage{
get_avg_activity_diff_based_on_synergy_set_cmp(synergy.set.str,
  synergy.subset.str, model.predictions, models.stable.state)
}
\arguments{
\item{synergy.set.str}{a string of drug combinations, comma-separated. The
number of the specified combinations must be larger than the ones defined
in the \code{synergy.subset.str} parameter. They also must be included in the
tested drug combinations, i.e. the columns of the \code{model.predictions}
parameter.}

\item{synergy.subset.str}{a string of drug combinations, comma-separated.
There must be at least one combination defined and all of them should also
be included in the \code{synergy.set.str} parameter.}

\item{model.predictions}{a \code{data.frame} object with rows the models and
columns the drug combinations. Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models)}

\item{models.stable.state}{a matrix (nxm) with n models and m nodes. The row
names of the matrix specify the models' names
whereas the column names specify the name of the network nodes
(gene, proteins, etc.). Possible values for each \emph{model-node element}
are either \emph{0} (inactive node) or \emph{1} (active node).}
}
\value{
a numeric vector with values in the [-1,1] interval (minimum and
maximum possible average difference) and with the names attribute
representing the name of the nodes.
}
\description{
This function splits the models to 'good' and 'bad' based on the predictions
of two different synergy sets, one of them being a subset of the other.
The 'good' models are those that predict the \code{synergy.set.str}
(e.g. "A-B,A-C,B-C") while the 'bad' models are those that predict the
\code{synergy.subset.str} (e.g. "A-B,B-C"). Then, for each network node,
the function finds the node's average activity in each of the two classes
(a value in the [0,1] interval) and then subtracts the bad class average
activity value from the good one.
}
\section{Details}{

So, if a node has a value close to -1 it means that on average,
this node is more \strong{inhibited} in the models that predicted the extra
synergy(-ies) that are included in the \code{synergy.set.str} but not in the
\code{synergy.subset.str}, whereas a value closer to 1 means that the node is
more \strong{activated} in these models. These nodes are \strong{potential
biomarkers} because their activity state can influence the prediction
performance of a model and make it predict the extra synergy(-ies).
A value closer to 0 indicates that the activity of that
node is \strong{not so much different} between the models that predicted the
synergy set and those that predicted it's subset, so it won't not be a node
of interest when searching for potential biomarkers for the extra synergy(-ies).
}

\seealso{
Other average data difference functions: \code{\link{get_avg_activity_diff_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_activity_diff_based_on_tp_predictions}},
  \code{\link{get_avg_activity_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_activity_diff_mat_based_on_tp_predictions}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_tp_predictions}}
}
\concept{average data difference functions}
