% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateAnchor.R
\name{GenerateAnchor}
\alias{GenerateAnchor}
\title{Generate a set of anchored parameters}
\usage{
GenerateAnchor(temperatures = NULL, nests = NULL, parameters = NULL,
  number.anchors = 7)
}
\arguments{
\item{temperatures}{A vector with temperatures to serve as anchors}

\item{nests}{Formated nest data or result object obtained from searchR()}

\item{parameters}{A set of parameters value}

\item{number.anchors}{Number of anchors}
}
\value{
A vector with parameters
}
\description{
Generate a set of anchored parameters.\cr
It is important that the anchors (i.e. the temperatures used as anchors) encompass 
the highest and lowest temperatures that are present in nests.\cr
The value for each anchor is R * 1E5. The 1E5 factor allows to value to be close to unity.
}
\details{
GenerateAnchor Generate a set of anchored parameters
}
\examples{
\dontrun{
# Example to generate anchored parameters
newp <- GenerateAnchor()
newp <- GenerateAnchor(temperatures=seq(from=20, 
  to=35, length.out=7))
newp <- GenerateAnchor(number.anchors=7)
data(nest)
formated <- FormatNests(nest, previous=NULL)
newp <- GenerateAnchor(nests=formated)
newp <- GenerateAnchor(nests=formated, number.anchors=10)
data(resultNest_4p_SSM4p)
newp <- GenerateAnchor(nests=resultNest_4p_SSM4p, number.anchors=7)
newp <- GenerateAnchor(nests=resultNest_4p_SSM4p, temperatures=seq(from=20,
 to=35, length.out=10))
newp <- GenerateAnchor(nests=resultNest_4p_SSM4p, number.anchors=7)
newp <- c(newp, Scale=1)
}
}
\author{
Marc Girondot
}
