% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cforest.r
\name{fit_cforest}
\alias{fit_cforest}
\title{Fit conditional inference forest}
\usage{
fit_cforest(x, y, formula = y ~ ., ctrl_fun = party::cforest_unbiased, ...)
}
\arguments{
\item{x}{Dataset, observations as rows and descriptors as columns.}

\item{y}{Responses.}

\item{formula}{Formula linking response to descriptors.}

\item{ctrl_fun}{Which control function to use, see \code{\link[party]{cforest_control}}.}

\item{...}{Sent to the function specified by \code{ctrl_fun}.}
}
\value{
A fitted \code{\link[party]{cforest}} model.
}
\description{
A \code{\link[party]{cforest}} is a random forest based on conditional inference
trees, using the implementation in the \pkg{party} package.
These trees can be used for classification, regression or survival
analysis, but only the survival part has been properly tested so far.
}
\details{
The parameters to \code{\link[party]{cforest}} are set using a
\code{\link[party]{cforest_control}} object. You should read the documentation
as the default values are chosen for technical reasons, not predictive
performance!
Pay special attention to \code{mtry} which is set very low by default.
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{predict_cforest}},
  \code{\link{modeling_procedure}}
}

