% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.r
\name{pre_factor_to_logical}
\alias{pre_factor_to_logical}
\title{Convert factors to logical columns}
\usage{
pre_factor_to_logical(data, feature, base = 1L, drop = TRUE)
}
\arguments{
\item{data}{Pre-processed data set, as produced by \code{\link{pre_split}}.}

\item{feature}{Character vector with names of features to convert.
Defaults to all factors in the data set.}

\item{base}{Sent to \code{\link{factor_to_logical}}. To specify different bases for
different columns supply a vector or list with named elements.}

\item{drop}{Sent to \code{\link{factor_to_logical}}. To specify different bases for
different columns supply a vector or list with named elements.}
}
\description{
Factors will be converted to one logical column per level (or one fewer if a
base level is specified).
}
\examples{
x <- mtcars[-1]
x <- transform(x,
    cyl = factor(cyl, ordered=TRUE),
    vs = factor(vs),
    gear = factor(gear)
)
y <- mtcars$mpg
cv <- resample("crossvalidation", y)
data <- pre_split(x, y, cv[[1]]) \%>\%
    pre_factor_to_logical(base = c(cyl="4", vs="0"), 
                          drop=c(cyl=FALSE, gear=FALSE))
data$fit$x
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

