% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.r
\name{pvalue.survdiff}
\alias{pvalue.survdiff}
\title{Extracts p-value from a logrank test}
\usage{
\method{pvalue}{survdiff}(x, log_p = FALSE, ...)
}
\arguments{
\item{x}{Logrank test result, as returned by \code{\link[survival]{survdiff}}.}

\item{log_p}{Whether to return the logarithm of the p-value.}

\item{...}{Ignored. Kept for S3 consistency.}
}
\value{
p-value.
if(requireNamespace("survival", quitely = TRUE)){

  y <- survival::Surv(time=1:100, event=rep(1:0, each=50))
  groups <- rep(1:2, each=50)
  x <- survival::survdiff(y ~ groups)

  # Compare p-values of implementations
  print(x)
  pvalue(x)

}
}
\description{
Extracts p-value from a logrank test
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{pvalue}}
}

