% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-bas_webservices.R
\name{runBASwebservice_chunker}
\alias{runBASwebservice_chunker}
\title{Creates a chunk segmentation using the webservice Chunker.}
\usage{
runBASwebservice_chunker(handle, canoAttributeDefinitionName, language,
  chunkAttributeDefinitionName = "TRN", rootLevel = NULL,
  orthoAttributeDefinitionName = NULL, params = list(force = "rescue"),
  perspective = "default", resume = FALSE, verbose = TRUE)
}
\arguments{
\item{handle}{emuDB handle}

\item{canoAttributeDefinitionName}{name of the attribute (not level!) containing a canonical pronunciation of the words.}

\item{language}{language(s) to be used. If you pass a single string (e.g. "deu-DE"), this language will be used for all bundles.
Alternatively, you can select the language for every bundle individually. To do so, you must pass a data frame with the columns
session, bundle, language. This data frame must contain one row for every bundle in your emuDB.
Up-to-date lists of the languages accepted by all webservices can be found here:
\url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}}

\item{chunkAttributeDefinitionName}{attribute name for the chunk segmentation}

\item{rootLevel}{if provided, the new level will be linked to the root level}

\item{orthoAttributeDefinitionName}{if provided, chunk attributes will contain orthographic instead of SAMPA strings.
Must be paired with the canonical pronunciation attributes in canoAttributeDefinitionName.}

\item{params}{named list of parameters to be passed on to the webservice. It is your own reponsibility to
ensure that these parameters are compatible with the webservice API
(see \url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}).
Some options accepted by the API (e.g. output format) cannot be set when calling a webservice from within emuR,
and will be overridden.}

\item{perspective}{the webApp perspective that the new level will be added to.
If NULL, the new level is not added to any perspectives.}

\item{resume}{If a previous call to this function has failed (and you think you have fixed the issue
that caused the error), you can set resume=TRUE to recover any progress made up to that point. This
will only work if your R temporary directory has not been deleted or emptied in the meantime.}

\item{verbose}{Display progress bars and other information}
}
\description{
When audio input files are longer than approximately 10 minutes, alignment-based segmentation
tools such as MAUS will take a long time to run. In these cases, the Chunker pre-segments
the input into more digestable "chunks". As input, it requires a word tier with canonical
pronunciation attributes (which can be derived by \link{runBASwebservice_g2pForPronunciation}).
The resulting chunk level can be passed as input to \link{runBASwebservice_maus}.
\strong{This function requires an internet connection.}
}
\details{
Please note that the chunker output is \strong{not} a semantically meaningful sentence
or turn segmentation, meaning that it cannot be used for analyses of sentence durations and the like.
By default, the chunker is called in force rescue mode. This means that the chunker is first run
in its normal mode, and switches to forced chunking mode only when it fails to find chunks that
are short enough for processing by MAUS. To disable the force mode completely, call this function with
params=list(force="false"). To skip the normal chunking mode and go directly into forced chunking
mode, use params=list(force="true").
}
\seealso{
Other BAS webservice functions: \code{\link{runBASwebservice_all}},
  \code{\link{runBASwebservice_g2pForPronunciation}},
  \code{\link{runBASwebservice_g2pForTokenization}},
  \code{\link{runBASwebservice_maus}},
  \code{\link{runBASwebservice_minni}},
  \code{\link{runBASwebservice_pho2sylCanonical}},
  \code{\link{runBASwebservice_pho2sylSegmental}}
}
