% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padronizar_tipos_de_logradouro.R
\name{padronizar_tipos_de_logradouro}
\alias{padronizar_tipos_de_logradouro}
\title{Padronizar tipos de logradouro}
\usage{
padronizar_tipos_de_logradouro(tipos)
}
\arguments{
\item{tipos}{Um vetor de caracteres. Os tipos de logradouro a serem
padronizados.}
}
\value{
Um vetor de caracteres com os tipos de logradouro padronizados.
}
\description{
Padroniza um vetor de caracteres representando tipos de logradouro. Veja a
seção \emph{Detalhes} para mais informações sobre a padronização.
}
\section{Detalhes}{

Operações realizadas durante a padronização:
\itemize{
\item remoção de espaços em branco antes e depois das strings e remoção de
espaços em excesso entre palavras;
\item conversão de caracteres para caixa alta;
\item remoção de acentos e caracteres não ASCII;
\item adição de espaços após abreviações sinalizadas por pontos;
\item expansão de abreviações frequentemente utilizadas através de diversas
\href{https://en.wikipedia.org/wiki/Regular_expression}{expressões regulares (regexes)};
\item correção de alguns pequenos erros ortográficos.
}
}

\examples{
tipos <- c("R", "AVE", "QDRA")
padronizar_tipos_de_logradouro(tipos)

}
