% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.R
\docType{data}
\name{storage}
\alias{storage}
\title{Natural Gas Storage Field Information}
\format{Data frame with columns
\describe{
\item{Company}{Name of the Storage Company}
\item{Field}{Name of the Storage Field}
\item{Reservoir}{Name of the Storage Reservoir}
\item{Type}{Type of Storage Field}
\item{County}{County Where the Field is Located}
\item{State}{State Where the Field is Located}
\item{Region}{AGA Region Where the Field is Located}
\item{Working}{Working Capacity in Mcf}
\item{Total}{Total Capacity in Mcf}
\item{MDD}{Maximum Daily Delivery in McF}
\item{address}{Location of the Field}
\item{lat}{Approximate Latitude of the Field}
\item{lon}{Approximate Longitude of the Field}
}}
\source{
http://www.ferc.gov/industries/gas/indus-act/storage.asp
}
\usage{
storage
}
\description{
Natural Gas Storage Field Information as reported by FERC.
}
\examples{
  dim(storage)
  head(storage)
}
\keyword{datasets}
