% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics.R
\name{count_topics}
\alias{count_topics}
\title{Count the number of topics by theme and by date}
\usage{
count_topics(topics, by_date = c("month_year", "year", "all"), .sort = TRUE)
}
\arguments{
\item{topics}{A tibble of topics by theme from \strong{en-net forum} produced
through a call to \code{\link[=get_themes_topics]{get_themes_topics()}}.}

\item{by_date}{Should topics be grouped by month of the year or just by
year or overall? Default is to group by month of the year.}

\item{.sort}{Logical. Should output be sorted by count frequencies? Default
is \emph{TRUE}.}
}
\value{
A tibble of topic counts by theme and by specified date format
}
\description{
Count the number of topics by theme and by date
}
\examples{
library(magrittr)
ennet_topics \%>\% count_topics(by_date = "month_year")

}
\author{
Ernest Guevarra
}
