% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patterns.r
\name{ENgetpatternid}
\alias{ENgetpatternid}
\title{Retrieve the ID label a time pattern}
\usage{
ENgetpatternid(patternindex)
}
\arguments{
\item{patternindex}{An integer specifying the time pattern index.}
}
\value{
A character string, the pattern ID label of the specified time pattern.
}
\description{
\code{ENgetpatternid} retrieves the ID label of a particular time pattern.
}
\note{
Pattern indexes are consecutive integers starting from 1.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetpatternid(1)
ENclose()
}
\seealso{
\url{http://wateranalytics.org/EPANET/group___patterns.html}
}
