% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_structure.R
\name{age_structure}
\alias{age_structure}
\title{Age structure under IPCC RCP2.6 or RCP8.5 scenarios}
\usage{
age_structure(
  y_ini = c(N1 = 800, N1 = 800, N1 = 800, N2 = 600, N2 = 600, N2 = 600, N3 = 400, N3 =
    400, N3 = 400),
  temp_ini = rep(25 + 273.15, 3),
  temp_cmin = rep(18 + 273.15, 3),
  temp_cmax = c(25 + 273.15, 28 + 273.15, 35 + 273.15),
  ro = rep(0.7, 3),
  lambda1 = rep(4e-04, 3),
  lambda2 = rep(4e-04, 3),
  lambda3 = rep(4e-04, 3),
  alpha1 = rep(0.1, 3),
  alpha2 = rep(0.7, 3),
  d2 = rep(0.005, 3),
  d3 = rep(0.5, 3),
  Ad2 = rep(0.5, 3),
  Ad3 = rep(0.75, 3),
  Tr2 = rep(298, 3),
  Tr3 = rep(298, 3),
  RCP = 2.6,
  time_start = 2005,
  time_end = 2100,
  leap = 1/50
)
}
\arguments{
\item{y_ini}{Initial population values (must be written with its name: N).}

\item{temp_ini}{Initial temperature (K).}

\item{temp_cmin}{Minimum critical temperature (K).}

\item{temp_cmax}{Maximum critical temperature (K).}

\item{ro}{Population growth rate at optimum temperature.}

\item{lambda1, lambda2, lambda3}{Marginal loss by non-thermodependent intraspecific competition.}

\item{alpha1, alpha2}{Stage 1 to 2 and 2 to 3 transition coefficient respectively.}

\item{d2, d3}{Mortality rate at a reference temperature.}

\item{Ad2, Ad3}{Arrhenius constant which quantifies the temperature sensitivity of mortality.}

\item{Tr2, Tr3}{Reference temperature (K).}

\item{RCP}{Representative concentration trajectories (RCP2.6 and RCP8.5 scenarios).}

\item{time_start}{Start of time sequence.}

\item{time_end}{End of time sequence.}

\item{leap}{Time sequence step.}
}
\value{
(1) A data.frame with columns having the simulated trends.

(2) Figure of four panels in which (a), (b) and (c) show the population abundance curves for
           each age stage. Panel (d) shows the temperature trend curves used for each simulation,
           colored brown, green and blue, respectively.
}
\description{
This function allows to simulate the effect of IPCC (2014) RCP2.6
            or RCP8.5 scenarios on the abundances of an ectotherm population
            considering three stages as age structure.
}
\details{
Three scenarios can be evaluated for a predation interaction where the prey is an ectotherm
        population. The temperature trends correspond to IPCC projections under the RCP2.6 or RCP8.5
        scenarios. In each input vector, the parameters for the three simulations must be specified.
}
\examples{
\donttest{
#######################################################################
  #Example 1: Different thermal tolerance ranges (scenario RCP2.6).
#######################################################################

temp_cmin <- 291

# Temperature that occurs before the minimum simulation time.
temp_i <- 295

time_end <- 2100

# Temperature that occurs in the maximum time of the simulation.
temp_max <- get_RCP2.6(time_end)+temp_i

# Simulation thermal range.
RS <- temp_max-temp_cmin

temp_cmax1 <- 4/3*RS+temp_cmin
temp_cmax2 <- 2/3*RS+temp_cmin
temp_cmax3 <- 1/3*RS+temp_cmin
temp_ini <- (temp_cmin+temp_cmax3)/2

age_structure(y_ini = c(N1 = 800, N1 = 800, N1 = 800,
                       N2 = 600, N2 = 600, N2 = 600,
                       N3 = 400, N3 = 400, N3 = 400),
             temp_ini = rep(temp_ini,3),
             temp_cmin = rep(temp_cmin,3),
             temp_cmax = c(temp_cmax1,temp_cmax2,temp_cmax3),
             ro = rep(0.7,3),
             lambda1 = c(0.00002,0,0),
             lambda2 = c(0,0.00004,0.00003),
             lambda3 = c(0,0.00003,0.00004),
             alpha1 = rep(0.3,3),
             alpha2 = rep(0.4,3),
             d2 = rep(0.004,3),
             d3 = rep(0.005,3),
             Ad2 = rep(0.5,3),
             Ad3 = rep(0.75,3),
             Tr2 = rep(298,3),
             Tr3 = rep(298,3),
             RCP = 2.6,
             time_start = 2005,
             time_end = time_end,
             leap = 1/50)

#######################################################################
  #Example 2: Different thermal tolerance ranges (scenario RCP8.5).
#######################################################################

temp_cmin <- 291

# Temperature that occurs before the minimum simulation time.
temp_i <- 295

time_end <- 2100

# Temperature that occurs in the maximum time of the simulation.
temp_max <- get_RCP8.5(time_end)+temp_i

# Simulation thermal range.
RS <- temp_max-temp_cmin

temp_cmax1 <- 4/3*RS+temp_cmin
temp_cmax2 <- 2/3*RS+temp_cmin
temp_cmax3 <- 1/3*RS+temp_cmin
temp_ini <- (temp_cmin+temp_cmax3)/2

age_structure(y_ini = c(N1 = 800, N1 = 800, N1 = 800,
                       N2 = 600, N2 = 600, N2 = 600,
                       N3 = 400, N3 = 400, N3 = 400),
             temp_ini = rep(temp_ini,3),
             temp_cmin = rep(temp_cmin,3),
             temp_cmax = c(temp_cmax1,temp_cmax2,temp_cmax3),
             ro = rep(0.7,3),
             lambda1 = c(0.00002,0,0),
             lambda2 = c(0,0.00004,0.00003),
             lambda3 = c(0,0.00003,0.00004),
             alpha1 = rep(0.3,3),
             alpha2 = rep(0.4,3),
             d2 = rep(0.004,3),
             d3 = rep(0.003,3),
             Ad2 = rep(0.5,3),
             Ad3 = rep(0.6,3),
             Tr2 = rep(298,3),
             Tr3 = rep(298,3),
             RCP = 8.5,
             time_start = 2005,
             time_end = time_end,
             leap = 1/50)
}
}
\references{
IPCC. (2014): Climate Change 2014: Synthesis Report. Contribution of Working Groups I,
           II and III to the Fifth Assessment Report of the Intergovernmental Panel on Climate
           Change [Core Writing Team, R.K. Pachauri and L.A. Meyer (eds.)]. IPCC, Geneva,
           Switzerland, 151 pp.
}
