% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional_priors.R
\name{hexp}
\alias{hexp}
\title{A hierarchical model for seeded infections}
\usage{
hexp(prior_aux = rstanarm::exponential(0.03))
}
\arguments{
\item{prior_aux}{Specifies the prior distribution on the auxiliary parameter.
This can be a call to \code{\link[rstanarm]{normal}}, \code{\link[rstanarm]{student_t}}
or \code{\link[rstanarm]{exponential}}.}
}
\value{
A named list to be parsed internally by \code{\link[epidemia]{epim}}.
}
\description{
This distribution assigns seeded infections in each population an
exponential prior. The \code{aux} parameter refers to the mean of this
distribution. This mean parameter is common to seeded infections in each
group, and is given a prior distribution. This approach of assigning
priors to hyperparameters is referred to as hierarchical modeling. A call
to this function can be passed as the \code{prior_seeds} argument in
\code{\link[epidemia]{epiinf}}.
}
\references{
\insertAllCited{}
}
