% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{posterior_coverage}
\alias{posterior_coverage}
\title{Coverage of posterior credible intervals}
\usage{
posterior_coverage(
  object,
  type,
  newdata = NULL,
  groups = NULL,
  levels = c(50, 95)
)
}
\arguments{
\item{object}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{type}{A string specifying the name of the observations to plot. This should match one
of the names of the response variables in the \code{obs} argument used int the call to \code{\link{epim}}.}

\item{newdata}{If provided, the original \code{data} used
in \code{object} is overridden. Useful for forecasting}

\item{groups}{Either \code{NULL} or a character vector specifying the groups
to plot for. Default is \code{NULL}, which plots all modeled groups.}

\item{levels}{A numeric vector defining the levels of the plotted
credible intervals.}
}
\value{
A dataframe indicating whether observations fall within the
specified credible intervals
}
\description{
Calculate daily error using one of three metrics, and also return coverage
of credible intervals. Uses continuous ranked probability
score (CRPS), mean absolute error and median absolute error.
}
