% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.epmGrid.R
\name{plot.epmGrid}
\alias{plot.epmGrid}
\title{Plot epmGrid}
\usage{
\method{plot}{epmGrid}(
  x,
  log = FALSE,
  legend = TRUE,
  col,
  basemap = "worldmap",
  colorRampRange = NULL,
  minTaxCount = "auto",
  zoom = TRUE,
  ignoredColor = gray(0.9),
  lwd,
  borderCol = "black",
  alpha = 1,
  includeFrame = FALSE,
  use_tmap = TRUE,
  fastPoints = FALSE,
  title = "",
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{object of class \code{epmGrid}}

\item{log}{boolean; should the cell values be logged?}

\item{legend}{boolean; should legend be included?}

\item{col}{either a vector of color names that will be interpolated, 
or a color ramp function that takes an integer 
(see for example \code{\link{colorRampPalette}}).}

\item{basemap}{if \code{'none'}, then only the grid is plotted. 
If \code{'worldmap'}, then vector map is plotted.
If \code{'interactive'}, then the plot is sent to the web browser.}

\item{colorRampRange}{numeric vector of min and max value for scaling the 
color ramp. Automatically inferred if set to \code{NULL}. 
This is relevant if multiple plots are desired on the same scale. 
See \code{\link{getMultiMapRamp}}.}

\item{minTaxCount}{an integer, or 'auto'. Should cells 
containing certain numbers of taxa be grayed out? For example, 
should single-taxon cells be ignored because the metric only makes sense 
for multi-taxon cells? This is predetermined for all metrics in
 \code{\link{gridMetrics}} if  minTaxCount = 'auto'.}

\item{zoom}{Should plot zoom in on cells with data. Default is TRUE.}

\item{ignoredColor}{color for ignored cells. See details.}

\item{lwd}{grid cell border width}

\item{borderCol}{color for grid cell borders}

\item{alpha}{opacity of all colors and borders, ranging from 0 
(fully transparent) to 1 (fully opaque)}

\item{includeFrame}{boolean; include frame around plot?}

\item{use_tmap}{boolean; if FALSE, plotting will be done via sf 
instead of tmap package}

\item{fastPoints}{Intended for debugging purposes. For hex grids and \code{use_tmap = F}, plot points instead of polygons. Helpful for sorting out plotting 
details without waiting for slow polygon plotting.}

\item{title}{text to add to the plot}

\item{add}{logical, add to existing plot?}

\item{...}{additional arguments that can be passed to sf::plot or terra::plot 
if \code{use_tmap = FALSE}}
}
\value{
Nothing is returned if plotting with tmap (the default). 
If plotting with \code{use_tmap = FALSE}, and if the plot is directed to 
a variable, then this variable will contain relevant information to be passed
on to the function \code{\link{addLegend}}:
}
\description{
Plot a epmGrid object. This function uses the tmap package 
for plotting by default.
}
\details{
If \code{x} is a metric as generated with \code{gridMetrics} 
that returns 0 for single-species cells, then those cells 
(that have a value of 0) will be plotted in gray (or any color as specified 
with \code{ignoredColor}) if \code{minTaxCount = 'auto'}. You can specify
other values as well. For instance, if you use the function
\code{\link{customGridMetric}} to calculate phylogenetic signal, which is 
a metric that only makes sense for cells with 3 or more taxa, then you could 
then specify \code{minTaxCount = 3}. Setting \code{minTaxCount = 1} shows all
cells with data.

If the tmap package is not installed, then this function will default 
to plotting with \code{sf::plot}.

If you would like more control over the legend, then plot with 
\code{tmap = FALSE} and \code{legend = FALSE}, and then call the function
\code{\link{addLegend}}.
}
\examples{
plot(tamiasEPM, use_tmap = FALSE)

plot(tamiasEPM, legend = FALSE, use_tmap = FALSE, col = viridisLite::inferno)
addLegend(tamiasEPM, location = 'top', ramp = viridisLite::inferno)

\donttest{ 
# Example for how to plot multiple epmGrids on the same color scale
# for illustration purposes, we will compare weighted endemism to
# phylogenetic weighted endemism
library(tmap)

tamiasEPM <- addPhylo(tamiasEPM, tamiasTree)
epm1 <- gridMetrics(tamiasEPM, metric='weightedEndemism')
epm2 <- gridMetrics(tamiasEPM, metric='phyloWeightedEndemism')
# get global min and max values
minmax <- getMultiMapRamp(epm1, epm2)

map1 <- plot(epm1, colorRampRange = log(minmax), log = TRUE, legend = FALSE)
map2 <- plot(epm2, colorRampRange = log(minmax), log = TRUE, legend = FALSE)
# tmap_arrange(map1, map2)

# view your plot in the web-browser as a dynamic plot.
plot(tamiasEPM, basemap = 'interactive')
}

# Adding a custom legend, and passing along arguments via params
xx <- plot(tamiasEPM, use_tmap = FALSE, legend = FALSE, 
col = viridisLite::magma)
addLegend(tamiasEPM, params = xx, location = 'bottom')

}
\author{
Pascal Title
}
