% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropSpecies.R
\name{dropSpecies}
\alias{dropSpecies}
\title{Drop species from epmGrid}
\usage{
dropSpecies(x, sp)
}
\arguments{
\item{x}{object of class \code{epmGrid}}

\item{sp}{a character vector of species names to be dropped.}
}
\value{
new \code{epmGrid} object.
}
\description{
Removes particular species from a epmGrid object.
}
\details{
If species in \code{sp} are not in \code{x}, they will be ignored.
}
\examples{
tamiasEPM

new <- dropSpecies(tamiasEPM, sp = c('Tamias_alpinus', 'Tamias_bulleri'))

setdiff(tamiasEPM[['geogSpecies']], new[['geogSpecies']])


}
\author{
Pascal Title
}
