% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeEpmSpatial.R
\name{writeEpmSpatial}
\alias{writeEpmSpatial}
\title{Write epmGrid Spatial Object to Disk}
\usage{
writeEpmSpatial(x, filename, ...)
}
\arguments{
\item{x}{object of class \code{epmGrid}}

\item{filename}{filename to be written to, with the appropriate file
extension}

\item{...}{additional arguments to be passed to \code{\link[sf]{st_write}} or
\code{\link[terra]{writeRaster}}.}
}
\value{
the object is written to disk, nothing is returned.
}
\description{
Writes the grid to disk for use in other GIS applications.
}
\details{
For hexagonal grid systems, appending .shp to the filename will
 result in a shapefile, whereas appending .gpkg results in a geopackage
 file. See \code{\link[sf]{st_write}} for additional options. For square
 grid cells, appending .tif will result in a GeoTiff file being written to
 disk. If no extensions are included with the filename, then this function
 will default to geopackage files for hexagonal grids and GeoTiffs for
 square grids.
}
\examples{
\donttest{
tamiasEPM
tamiasEPM2 <- createEPMgrid(tamiasPolyList, resolution = 50000,
cellType = 'square', method = 'centroid')
writeEpmSpatial(tamiasEPM, filename = paste0(tempdir(), '/tamiasGrid.shp'))
writeEpmSpatial(tamiasEPM, filename = paste0(tempdir(), '/tamiasGrid.gpkg'))
unlink(paste0(tempdir(), '/tamiasGrid.gpkg'))
# will automatically append .gpkg
writeEpmSpatial(tamiasEPM, filename = paste0(tempdir(), '/tamiasGrid')) 

writeEpmSpatial(tamiasEPM2, filename = paste0(tempdir(), '/tamiasGrid.tif'))
unlink(paste0(tempdir(), '/tamiasGrid.tif'))
# will automatically append .tif
writeEpmSpatial(tamiasEPM2, filename = paste0(tempdir(), '/tamiasGrid'))

# remove files generated by example
unlink(paste0(tempdir(), '/tamiasGrid', c('.dbf', '.gpkg', '.prj', '.shp', '.shx', '.tif')))
}
}
\author{
Pascal Title
}
