% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstDataSimulation.R
\name{mstDataSimulation}
\alias{mstDataSimulation}
\title{Simulate Multisite Trial (MST) Data}
\usage{
mstDataSimulation(
  ni,
  ns,
  np,
  tpi,
  sigma,
  sigmab0,
  sigmab1,
  sigmaPret,
  B0,
  B1,
  es,
  seed,
  attritionrates
)
}
\arguments{
\item{ni}{The number of intervention groups excluding the control group.}

\item{ns}{The number of schools.}

\item{np}{The number of pupils per school.}

\item{tpi}{The proportions (in percent) of total participants assigned to each group, with the first value for the control group. It should be specified as a numeric vector of length ni + 1.}

\item{sigma}{The standard deviation of the individual-level error.}

\item{sigmab0}{The standard deviation of random intercepts at the school level.}

\item{sigmab1}{The standard deviation of random slopes for the intervention effect.}

\item{sigmaPret}{The standard deviation of the pretest scores.}

\item{B0}{The intercept of the model.}

\item{B1}{The coefficient for the pretest score in the model.}

\item{es}{The standardized effect sizes for each intervention group. It should be specified as a numeric vector.}

\item{seed}{The random seed for reproducibility.}

\item{attritionrates}{The attrition proportions for each group, including the control group. It should be specified as a numeric vector of length ni + 1.}
}
\value{
A \code{data.frame} containing:
\describe{
\item{pupils}{Pupil ID}
\item{schools}{School ID}
\item{interventions}{Intervention group assignment (0 = control, 1 to \code{ni} = intervention groups)}
\item{pretest}{Pretest score}
\item{posttest}{Posttest score (NA if attrited)}
}
}
\description{
This function simulates a multiple intervention arms Multisite Trial (MST) data. The model
includes intervention and pre-test scores as covariates.
}
\examples{
mstdata <- mstDataSimulation(ni = 3, ns = 10, np = 100, tpi = c(30, 30, 20, 20),
sigma = 1, sigmab0 = 0.5, sigmab1 = 0.5, sigmaPret = 1, B0 = 0, B1 = 0.5,
es = c(0.2, 0.3, 0.1), seed = 1234, attritionrates = c(0.1, 0.1, 0.1, 0)) 
head(mstdata)

}
