\name{alignComp}
\alias{alignComp}
\title{Alignment of compounds}
\description{Alignment of GC-MS deconvolved compounds}
\usage{
alignComp(Experiment, alParameters, blocks.size=NULL)
}
\arguments{
  \item{Experiment}{A 'MetaboSet' S4 object containing the experiment data previously created by newExp and deconvolved by deconvolveComp.}
  \item{alParameters}{The software alignment parameters object previously created by setAlPar}
  \item{blocks.size}{For experiment of more than 1000 samples, and depending on the computer, alignment can be conducted by block segmentation. See details.} 
}
\details{
See eRah vignette for more details. To open the vignette, execute the following code in R:
vignette("eRahManual", package="erah")

For experiments containing more than 100 (Windows) or 1000 (Mac or Linux) samples (numbers depending on the computer resoures and sample type). In those cases alignment can be conducted by block segmentation. For an experiment of e.g. 1000 samples, the block.size can be set to 100, so the alignment will perform as multiple (ten) 100-samples experiments, to later align them into a single experiment.

This parameter is designed to solve the typical problem that appear when aligning under Windows operating system: "Error: cannot allocate vector of size XX Gb". Such a problem will not appear with Mac or Linux, but several hours of computation are expected when aligning a large number of samples. Using block segmentation provides a greatly improved run-time performance.

}
\value{
The function returns an updated S4 'MetaboSet' class, where the GC-MS samples have been now aligned.
}
\references{
[1] Xavier Domingo-Almenara, et al., eRah: A Computational Tool Integrating Spectral Deconvolution and Alignment with Quantification and Identification of Metabolites in GC-MS-Based Metabolomics. Analytical Chemistry (2016). DOI: 10.1021/acs.analchem.6b02927 
}
\author{
Xavier Domingo-Almenara. xavier.domingoa@eurecat.org
}

\seealso{
\code{\link{newExp}}, \code{\link{setDecPar}}, \code{\link{deconvolveComp}}
}



