% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.hotelling.diff.test.R
\name{approx.hotelling.diff.test}
\alias{approx.hotelling.diff.test}
\title{Approximate Hotelling T^2-Test for One Sample Means}
\usage{
approx.hotelling.diff.test(x, y = NULL, mu0 = 0,
  assume.indep = FALSE, var.equal = FALSE)
}
\arguments{
\item{x}{a numeric matrix of data values with cases in rows and
variables in columns.}

\item{y}{an optinal matrix of data values with cases in rows and
variables in columns for a 2-sample test.}

\item{mu0}{an optional numeric vector: for a 1-sample test, the
poulation mean under the null hypothesis; and for a 2-sample
test, the difference between population means under the null
hypothesis; defaults to a vector of 0s.}

\item{assume.indep}{if \code{TRUE}, performs an ordinary Hotelling's
test without attempting to account for autocorrelation.}

\item{var.equal}{for a 2-sample test, perform the pooled test:
assume population variance-covariance matrices of the two
variables are equal.}
}
\value{
An object of class \code{htest} with the following information:
\item{statistic}{The \eqn{T^2} statistic.}
\item{parameter}{Degrees of freedom.}
\item{p.value}{P-value.}
\item{method}{Method specifics.}
\item{null.value}{Null hypothesis mean or mean difference.}
\item{alternative}{Always \code{"two.sided"}.}
\item{estimate}{Sample difference.}
\item{covariance}{Estimated variance-covariance matrix of the estimate of the difference.}

It has a print method \code{\link[=print.htest]{print.htest()}}.
}
\description{
A multivariate hypothesis test for a single population mean or a
difference between them. This version attempts to adjust for
multivariate autocorrelation in the samples.
}
\note{
For \code{\link{mcmc.list}} input, the variance for this test is
estimated with unpooled means. This is not strictly correct.
}
\references{
Hotelling, H. (1947). Multivariate Quality Control. In C. Eisenhart, M. W.
Hastay, and W. A. Wallis, eds. Techniques of Statistical Analysis. New York:
McGraw-Hill.
}
\seealso{
\code{\link[=t.test]{t.test()}}
}
