% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconv_ww_inc.R
\name{deconv_ww_inc}
\alias{deconv_ww_inc}
\title{Deconvoluting Wastewater Data to Incidence}
\usage{
deconv_ww_inc(d, fec, scaling.factor, silent, RL.max.iter)
}
\arguments{
\item{d}{Data frame. Wastewater dataframe. Must include at least \code{date}, time \code{t} and
\code{obs} columns.}

\item{fec}{List. Parameters for a single fecal shedding distribution, as generated by \code{\link[=sample_a_dist]{sample_a_dist()}}.}

\item{scaling.factor}{Numeric. Scaling from wastewater concentration to
prevalence. This value may be assumed or independently calibrated to data.}

\item{silent}{Logical. Flag to suppress all output messages, warnings, and progress bars.}

\item{RL.max.iter}{Integer. Maximum of iterations for the Richardson-Lucy deconvolution algorithm.}
}
\value{
Data frame with deconvoluted incidence
}
\description{
Function estimates incidence from smoothed data
}
\keyword{internal}
