% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{def_dist}
\alias{def_dist}
\title{Define a family of distributions.}
\usage{
def_dist(dist, ...)
}
\arguments{
\item{dist}{distribution type. Distributions currently supported are:
\itemize{
\item \code{norm} = normal,
\item \code{lnorm} = log-normal,
\item \code{gamma} = Gamma,
\item \code{unif} = uniform
}}

\item{...}{a series of distribution parameters.
Included should be the following:
\itemize{
\item \code{mean} distribution mean (only for \code{dist} = \code{lnorm} or \code{gamma}).
\item \code{mean_sd} standard deviation of the mean (only for \code{dist} = \code{lnorm}
or \code{gamma}).
\item \code{sd} standard deviation (only for \code{dist} = \code{lnorm} or \code{gamma}).
\item \code{sd_sd} standard deviation of the standard deviation (only for
\code{dist} = \code{lnorm} or \code{gamma}).
\item \code{min} minimum value of the random variable modelled by this distribution
(only for \code{dist} = \code{unif}).
\item \code{max} maximum value of the random variable modelled by this distribution.
}}
}
\value{
List with components specified in the parameters.
}
\description{
Define a family of distributions.
}
\examples{
d = def_dist(
  dist     = "gamma",
  mean     = 3.49,
  mean_sd  = 0.1477,
  shape    = 8.5,
  shape_sd = 1.8945,
  max      = 8
)
print(d)

}
