% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{get_discrete_dist}
\alias{get_discrete_dist}
\title{Get a discretized, truncated version of a distribution}
\usage{
get_discrete_dist(params)
}
\arguments{
\item{params}{distribution params (output of \verb{def_dist_*()} function)}
}
\value{
Numeric. Vector with discretized density.
}
\description{
Get a discretized, truncated version of a distribution
}
\examples{

# Define distributions
fec = ern::def_dist(
  dist = "gamma",
  mean = 12.90215,
  mean_sd = 1.136829,
  shape = 1.759937,
  shape_sd = 0.2665988,
  max = 33
  )
gi  = ern::def_dist(
  dist     = "gamma",
  mean     = 6.84,
  mean_sd  = 0.7486,
  shape    = 2.39,
  shape_sd = 0.3573,
  max      = 15
  )

# Get their (discretized) densities
d.fec = get_discrete_dist(fec)
d.gi  = get_discrete_dist(gi)

print(d.fec)
print(d.gi)

}
