% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_phase1_outcomes.R
\name{parse_phase1_outcomes}
\alias{parse_phase1_outcomes}
\title{Parse a string of phase I dose-finding outcomes to vector notation.}
\usage{
parse_phase1_outcomes(outcomes, as_list = TRUE)
}
\arguments{
\item{outcomes}{character string, conveying doses given and outcomes
observed.}

\item{as_list}{TRUE (the default) to return a \code{list};
FALSE to return a \code{data.frame}}
}
\value{
If \code{as_list == TRUE}, a list with elements \code{tox},
\code{doses} and \code{num_patients}. If \code{as_list == FALSE}, a
data.frame with columns \code{tox} and \code{doses}.
}
\description{
Parse a string of phase I dose-finding outcomes to a binary
vector notation necessary for model invocation.

The outcome string describes the doses given, outcomes observed and groups
patients into cohorts. The format of the string is described in Brock (2019),
and that itself is the phase I analogue of the similar idea described in
Brock et al. (2017). See Examples.

The letters T and N are used to represents patients that experienced
(T)oxicity and (N)o toxicity. These letters are concatenated after numerical
dose-levels to convey the outcomes of cohorts of patients.
For instance, \code{2NNT} represents a cohort of three patients that were
treated at dose-level 2, one of whom experienced toxicity, and two that did
not. The results of cohorts are separated by spaces. Thus, \code{2NNT 1NN}
extends our previous example, where the next cohort of two were treated at
dose-level 1 and neither experienced toxicity. See examples.
}
\examples{
x = parse_phase1_outcomes('1NNN 2NTN 3TTT')
# Three cohorts of three patients. The first cohort was treated at dose 1 and
# none had toxicity. The second cohort was treated at dose 2 and one of the
# three had toxicity. Finally, cohort three was treated at dose 3 and all
# patients had toxicity.
x$num_patients  # 9
x$doses         # c(1, 1, 1, 2, 2, 2, 3, 3, 3)
x$tox           # c(0, 0, 0, 0, 1, 0, 1, 1, 1)
sum(x$tox)      # 4

# The same information can be parsed to a data-frame:
y = parse_phase1_outcomes('1NNN 2NTN 3TTT', as_list = FALSE)
y
}
\references{
Brock, K. (2019). trialr: Bayesian Clinical Trial Designs in R and Stan.
arXiv:1907.00161 [stat.CO]

Brock, K., Billingham, L., Copland, M., Siddique, S., Sirovica, M., & Yap, C.
(2017). Implementing the EffTox dose-finding design in the Matchpoint trial.
BMC Medical Research Methodology, 17(1), 112.
https://doi.org/10.1186/s12874-017-0381-x
}
