% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview_nominal.R
\name{overview_nominal}
\alias{overview_nominal}
\title{Calculates descriptive statistics for a numerical variable}
\usage{
overview_nominal(
  data = NULL,
  outcome_variable = NULL,
  grouping_variable = NULL,
  cases = NULL,
  outcome_variable_levels = NULL,
  outcome_variable_name = "My Outcome Variable",
  grouping_variable_name = "My Grouping Variable",
  conf_level = 0.95,
  count_NA = FALSE
)
}
\arguments{
\item{data}{\itemize{
\item for raw data, a data frame or tibble
}}

\item{outcome_variable}{\itemize{
\item for raw data, either a vector containing factor
data or the name of a data-frame column containing a factor
}}

\item{grouping_variable}{\itemize{
\item for raw data, either NULL (default), or
the vector of a factor or a data-frame column containing a factor
}}

\item{cases}{For summary data - A vector of 1 or more counts, integers>0}

\item{outcome_variable_levels}{For summary data - An optional vector of
group labels, same length as cases.  If not passed, auto-generated.}

\item{outcome_variable_name}{Optional friendly name for the outcome variable.
Defaults to 'My Outcome Variable'.  Ignored if a data-frame is passed,
this argument is ignored.}

\item{grouping_variable_name}{Optional friendly name for the grouping variable.
Defaults to 'My Grouping Variable'.  Ignored for summary data and for
data frames -- only used if vectors of data are passed.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{count_NA}{Logical to count NAs (TRUE) in total N or not (FALSE)}
}
\value{
Returns a table of descriptive statistics
\itemize{
\item \strong{overview_nominal}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{outcome_variable_level} -
\item \emph{cases} -
\item \emph{n} -
\item \emph{P} -
\item \emph{P_LL} -
\item \emph{P_UL} -
\item \emph{P_SE} -
\item \emph{P_adjusted} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
}
}
\description{
This function calculated basic descriptive statistics for a categorical/
nominal variable. Inputs can be summary data, vectors, or a data frame.
}
\examples{
# example code
esci::overview_nominal(esci::data_latimier_3groups, "Group")

}
