% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_magnitude.R
\name{plot_magnitude}
\alias{plot_magnitude}
\title{Plot the mean or median for a continuous variable}
\usage{
plot_magnitude(
  estimate,
  effect_size = c("mean", "median"),
  data_layout = c("random", "swarm", "none"),
  data_spread = 0.25,
  error_layout = c("halfeye", "eye", "gradient", "none"),
  error_scale = 0.3,
  error_nudge = 0.35,
  error_normalize = c("groups", "all", "panels"),
  rope = c(NA, NA),
  ggtheme = NULL
)
}
\arguments{
\item{estimate}{\itemize{
\item An esci_estimate object generated by
\code{\link[=estimate_magnitude]{estimate_magnitude()}}
}}

\item{effect_size}{\itemize{
\item Optional; One of 'mean' (default) or 'median'; specifies
which measure of central tendency to highlight; note medians are only
available if the esci_estimate object was generated from raw data
}}

\item{data_layout}{\itemize{
\item Optional; One of 'random' (default), 'swarm', or 'none'
for how raw data (if available) will be displayed
}}

\item{data_spread}{\itemize{
\item Optional real number > 0 specifying width raw data (if
available) should take on the graph; default is 0.25; default spacing
between two groups on the graph is 1
}}

\item{error_layout}{\itemize{
\item Optional; One of 'halfeye', 'eye', 'gradient' or 'none'
for how expected sampling error of the measure of central tendency should
be displayed.  Currently, only applies if 'mean' is selected as measure of
central tendency
}}

\item{error_scale}{\itemize{
\item Optional real number > 0 specifying width of the expected
sampling error visualization; default is 0.3
}}

\item{error_nudge}{\itemize{
\item Optional amount by which error distribution should be
offset; default is 0.35
}}

\item{error_normalize}{\itemize{
\item Optional; One of 'groups' (default), 'all', or
'panels' specifying how width of expected sampling error distributions
should be calculated.
}}

\item{rope}{\itemize{
\item Optional two-item vector specifying a region of practical
equivalence (ROPE) to be highlighted on the plot.  For a point null
hypothesis, pass the same value (e.g. c(0, 0) to test a point null of
exactly 0); for an interval null pass ascending values (e.g. c(-1, 1))
}}

\item{ggtheme}{\itemize{
\item Optional ggplot2 theme object to control overall styling;
defaults to \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}
}}
}
\value{
Returns a ggplot object
}
\description{
\code{plot_magnitude} creates a ggplot2 plot suitable for visualizing
the results of a study with one group and one or more continuous outcome
variables.  It can highlight either the mean or median of each outcome
variable.  This function can be passed an esci_estimate object generated by
\code{\link[=estimate_magnitude]{estimate_magnitude()}}
}
\details{
This function was developed primarily for student use within jamovi when
learning along with the text book Introduction to the New Statistics, 2nd
edition (Cumming & Calin-Jageman, 2024).

Expect breaking changes as this function is improved for general use.  Work
still do be done includes:
\itemize{
\item Revise to avoid deprecated ggplot features
\item Revise for consistent ability to control aesthetics and consistent
layer names
}
}
\examples{
# From raw data
data("data_penlaptop1")

estimate_from_raw <- esci::estimate_magnitude(
  data = data_penlaptop1[data_penlaptop1$condition == "Pen", ],
    outcome_variable = transcription
)

# To visualize the estimate
myplot_from_raw <- esci::plot_magnitude(
  estimate_from_raw,
  effect_size = "median"
)


# From summary data
mymean <- 24.5
mysd <- 3.65
myn <- 40

estimate_from_summary <- esci::estimate_magnitude(
  mean = mymean,
  sd = mysd,
  n = myn
)

# To visualize the estimate
myplot_from_summary <- esci::plot_magnitude(
  estimate_from_summary,
  effect_size = "mean"
)


}
