% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_getIRISdata.R
\name{aux_getIRISdata}
\alias{aux_getIRISdata}
\title{Download seismic data from IRIS data base}
\usage{
aux_getIRISdata(
  start,
  duration,
  sncl,
  quality = "D",
  ID_iris = "IrisClient",
  eseis = TRUE
)
}
\arguments{
\item{start}{\code{POSIXct} value, start time of the data to query.}

\item{duration}{\code{Numeric} value, length of the data to query, in 
seconds.}

\item{sncl}{\code{Character} vector, SNCL string used to identify station 
and component of interest. These strings should match the time criteria. 
Typically, the SNCL string can be taken from the output of the function
\code{aux_getirisstations}.}

\item{quality}{\code{Character} value, quality level of the data. One out 
of \code{"D"} (The state of quality control of the data is indeterminate), 
\code{"R"} (Raw Waveform Data with no Quality Control), 
\code{"Q"} (Quality Controlled Data, some processes have been applied to 
the data), \code{"M"} (Data center modified, time-series values have not 
been changed), \code{"B"}. Default is \code{"D"}.}

\item{ID_iris}{\code{Character} value, IRIS ID. Default is 
\code{"IrisClient"}.}

\item{eseis}{\code{Logical} scalar, option to read data to an \code{eseis}
object (recommended, see documentation of 
\code{aux_initiateeseis}), default is \code{TRUE}}
}
\value{
\code{List} with downloaded seismic data. For each element in 
\code{sncl}, a list element is created, which in turn contains a list with 
the typical seismic data organisation as, for example, created by 
\code{read_sac}.
}
\description{
This function accesses the IRIS internet data base of seismic signals and 
downloads seismic data based on the provided SNCL string and time 
information. The downloaded data is converted to the same structure as 
would be expected from \code{read_sac} or \code{read_mseed}.
}
\details{
The function makes use of the package 'IRISSeismic'. It requires a working 
internet connection to perform the download.
}
\examples{

\dontrun{

sncl <- aux_getIRISstation(start = as.POSIXct("2010-01-01 22:22:22", 
                                               tz = "UTC"), 
                            duration = 120, 
                            location = c(53, 13), 
                            radius = 0.7, 
                            component = "BHZ")

s <- aux_getIRISdata(start = as.POSIXct("2010-01-01 22:22:22", 
                                           tz = "UTC"), 
                        duration = 120,
                        sncl = sncl$sncl[1])
                        
plot_signal(data = s[[1]])
}
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
