% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_similarity_from_bin.R
\name{sp.similarity.from.bin}
\alias{sp.similarity.from.bin}
\title{Volume-based spatial similarity metrics calculated from binary modality 3D volumes.
\loadmathjax}
\usage{
sp.similarity.from.bin(
  vol.A,
  vol.B,
  coeff = c("DSC", "DJC", "MDC", "under.MDC", "over.MDC")
)
}
\arguments{
\item{vol.A, vol.B}{"volume" class objects, of \code{"binary"} modality}

\item{coeff}{Vector indicating the requested metrics from among
'DSC' (Dice similarity coefficient),'DJC' (Dice-Jaccard coefficient),
and 'MDC' (mean distance to conformity). Equal to \code{NULL} if not requested.}
}
\value{
returns a dataframe containing (if requested):
\itemize{
\item volumetric Dice similarity coefficient \code{DSC} defined by :
\mjdeqn{DSC = 2 \frac{V_{A} ~\cap~ V_{B}}{V_{A} + V_{B}}}{ascii}
\item Dice-Jaccard coefficient \code{DJC} defined by :
\mjdeqn{DJC = \frac{V_{A} ~\cap~ V_{B}}{V_{A} ~\cup~ V_{B}}}{ascii}
\item mean distance to conformity \code{MDC}, over-contouring mean distance
\code{over.MDC}and under-contouring mean distance \code{under.MDC}, defined by
\emph{Jena et al} \strong{[1]}
}
}
\description{
The \code{sp.similarity.from.bin} function computes volumetric Dice
similarity coefficient, Dice-Jaccard coefficient and Dice surface similarity coefficient.
}
\examples{
# creation of to volume" class objects, of "binary" modality
vol.A <- vol.create (pt000 = c(-25,-25,0), dxyz = c (1 , 1, 1),
                    n.ijk = c(50, 50, 1), default.value = FALSE,
                    ref.pseudo = "ref1",
                    alias = "vol.A", modality = "binary",
                    description = "") 
vol.B <- vol.copy (vol.A,alias = "vol.B")   
vol.A$vol3D.data [as.matrix(expand.grid(15:35,20:35,1))] <- TRUE
vol.A$max.pixel <- TRUE
vol.B$vol3D.data [as.matrix(expand.grid(16:36,18:37,1))] <- TRUE
vol.B$max.pixel <- TRUE
display.plane (vol.A, vol.B, interpolate = FALSE, 
               main = "vol.A & vol.B @ z = 0 mm") 
               
sp.similarity.from.bin (vol.A, vol.B)
}
\references{
\strong{[1]} \insertRef{JENA201044}{espadon}
}
\seealso{
\link[espadon]{sp.similarity.from.mesh}
}
