% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometries.R
\name{geoms}
\alias{geoms}
\alias{potential_geoms}
\alias{potential_geoms_ref}
\title{Potential geometries according to the data}
\usage{
potential_geoms(data, mapping, auto = FALSE)

potential_geoms_ref()
}
\arguments{
\item{data}{A \code{data.frame}}

\item{mapping}{List of aesthetic mappings to use with data.}

\item{auto}{Return only one geometry.}
}
\value{
A \code{character} vector
}
\description{
From the data and variable used in aesthetics, decide which geometry can be used and which one is used by default.
}
\examples{

library(ggplot2)

# One continuous variable
potential_geoms(
  data = iris,
  mapping = aes(x = Sepal.Length)
)

# Automatic pick a geom
potential_geoms(
  data = iris,
  mapping = aes(x = Sepal.Length),
  auto = TRUE
)

# One discrete variable
potential_geoms(
  data = iris,
  mapping = aes(x = Species)
)

# Two continuous variables
potential_geoms(
  data = iris,
  mapping = aes(x = Sepal.Length, y = Sepal.Width)
)
# Reference used by esquisse to select available geoms
# and decide which one to use by default
potential_geoms_ref()
}
