% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binned_utils.R
\name{qtile_mean_diffs}
\alias{qtile_mean_diffs}
\title{Compute mean differences by various quantiles}
\usage{
qtile_mean_diffs(formula, data, qtiles = seq(0, 1, 0.33))
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note the
grouping variable must only include only two groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{qtiles}{Quantile bins for calculating mean differences}
}
\description{
Compute mean differences by various quantiles
}
\examples{
qtile_mean_diffs(reading ~ condition, star)

qtile_mean_diffs(reading ~ condition, 
		star, 
		qtiles = seq(0, 1, .2))
}
