% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_import.R
\name{importData}
\alias{importData}
\title{Download and import a Eurostat dataset}
\usage{
importData(EurostatDatasetCode)
}
\arguments{
\item{EurostatDatasetCode}{A string (upper/lower-case difference is not relevant) with Eurostat dataset code name,
e.g. \code{nama_10_gdp} or \code{bop_its6_det}. See \url{https://ec.europa.eu/eurostat/databrowser/explore/all/all_themes}
to find a dataset code -- the dataset codes are in tiny font in square brackets.}
}
\value{
A Eurostat dataset as a `flat' data.frame.
A `flat' dataset has all numeric values in one column, with each row representing one of the available combinations
of all dimensions (e.g. if dimensions are: countries, years, sectors, and indicators, there can be a row for value
added in retail in Germany in 2013).
}
\description{
Download and import a Eurostat dataset
}
\examples{
\dontrun{
importData('nama_10_gdp')
}
}
