% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{importDimLabel}
\alias{importDimLabel}
\title{Import Eurostat label (description) of a given dimension code}
\usage{
importDimLabel(EurostatDimCode)
}
\arguments{
\item{EurostatDimCode}{A string -- the code name of the Eurostat dimension, e.g. \code{"geo"} or \code{"nace_r2"}
or \code{"indic_sb"}, etc.}
}
\value{
A character vector of length 1: the label/description of \code{EurostatDimCode}.
}
\description{
Import the appropriate description file
for the selected Eurostat dimension, e.g. for \code{"geo"} it is \code{"Geopolitical entity (reporting)"},
for \code{"nace_r2"} it is \code{"Classification of economic activities - NACE Rev.2"},
for \code{"indic_sb"} it is \code{"Economical indicator for structural business statistics"} etc.
See \url{https://ec.europa.eu/eurostat/estat-navtree-portlet-prod/BulkDownloadListing?sort=1&dir=dic\%2Fen/}
for the list of all codes (the .dic file extension to be ignored).
Each description is web-scraped from a table (row "Label") at the specific url, e.g. for \code{"geo"} it is
\url{https://dd.eionet.europa.eu/vocabulary/eurostat/geo/}.
}
\examples{
\dontrun{
importDimLabel('nace_r2')
}
}
