% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{TrfInverseG}
\alias{TrfInverseG}
\title{Computes inverse of g from the marginal transform method (vectorised version).
That is from GPD(offset_shape, offset_scale) to GPD(alpha, beta+kappa).}
\usage{
TrfInverseG(z, alpha, beta, kappa, offset_scale, offset_shape)
}
\arguments{
\item{z}{Data distributed as GPD(offset_shape, offset_scale).}

\item{alpha}{Shape parameter of output data.}

\item{beta}{Part of scale parameter of output data (beta + kappa).
Should be positive.}

\item{kappa}{Part of scale parameter of output data.
Should be positive.}

\item{offset_scale}{Scale parameter of input data.
Should be positive.}

\item{offset_shape}{Shape parameter of input data.}
}
\value{
GPD(alpha, beta+kappa)-distributed data from
GPD(offset_shape, offset_scale)-distributed input data.
}
\description{
Computes inverse of g from the marginal transform method (vectorised version).
That is from GPD(offset_shape, offset_scale) to GPD(alpha, beta+kappa).
}
