% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{predict.evgam}
\alias{predict.evgam}
\alias{fitted.evgam}
\title{Predictions from a fitted \code{evgam} object}
\usage{
\method{predict}{evgam}(
  object,
  newdata = NULL,
  type = "link",
  probs = NULL,
  se.fit = FALSE,
  marginal = TRUE,
  ...
)

\method{fitted}{evgam}(object, ...)
}
\arguments{
\item{object}{a fitted \code{evgam} object}

\item{newdata}{a data frame}

\item{type}{a character string giving the type of prediction sought; see Details. Defaults to \code{"link"}}

\item{probs}{a scalar or vector of probabilities for quantiles to be estimated if \code{type == "quantile"}; defaults to 0.5}

\item{se.fit}{a logical: should estimated standard errors be returned? Defaults to FALSE}

\item{marginal}{a logical: should uncertainty estimates integrate out smoothing parameter uncertainty? Defaults to TRUE}

\item{...}{unused}
}
\value{
A data frame or list of predictions, or a plot if \code{type == "qqplot"}
}
\description{
Predictions from a fitted \code{evgam} object
}
\details{
There are five options for \code{type}: 1) \code{"link"} distribution parameters 
transformed to their model fitting scale; 2) \code{"response"} as 1), but on their 
original scale; 3) "lpmatrix" a list of design matrices; 4) "quantile"
estimates of distribution quantile(s); and 5) "qqplot" a quantile-quantile
plot.
}
\examples{

\donttest{

library(evgam)
data(COprcp)
COprcp$year <- format(COprcp$date, "\%Y")
COprcp_gev <- aggregate(prcp ~ year + meta_row, COprcp, max)
COprcp_gev <- cbind(COprcp_gev, COprcp_meta[COprcp_gev$meta_row,])
fmla_gev <- list(prcp ~ s(lon, lat, k=30) + s(elev, bs="cr"), ~ s(lon, lat, k=20), ~ 1)
m_gev <- evgam(fmla_gev, data=COprcp_gev, family="gev")
predict(m_gev, COprcp_meta)
predict(m_gev, COprcp_meta, type="response")
predict(m_gev, COprcp_meta, probs=.99)
COprcp_qq1 <- subset(COprcp_gev, name == "BOULDER")
predict(m_gev, COprcp_qq1, type="qqplot")
COprcp_qq2 <- subset(COprcp_gev, name \%in\% c("BOULDER", "FT COLLINS"))
predict(m_gev, COprcp_qq2, type="qqplot")
fitted(m_gev)

}

}
