% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{normalize_pdf}
\alias{normalize_pdf}
\title{Normalize a pdf}
\usage{
normalize_pdf(x, p_x)
}
\arguments{
\item{x}{a vector corresponding to values of a random variable X (length strictly greater than 1)}

\item{p_x}{a vector containing the density of the RV X at locations \code{x}}
}
\value{
The normalized pdf
}
\description{
\code{normalize_pdf} normalizes a pdf so that the integral of the pdf is equal
to 1
}
\examples{
x <- seq(from=-5,to=5,by=0.1)
p_x <- 2*dnorm(x)
res <- normalize_pdf(x,p_x)
plot(x,p_x)
lines(x,res$p_x)
lines(x,dnorm(x),col='red',lty=2)
}
