% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{n1.get.solution}
\alias{n1.get.solution}
\title{Find minimal n1 achieving target power for range of values of p0}
\usage{
n1.get.solution(data, beta, p0, delta, alpha, type = 1)
}
\arguments{
\item{data}{power database for selected value of alpha and delta (See
details)}

\item{beta}{scalar target for power}

\item{p0}{single value or range of values for baseline probability}

\item{delta}{value of clinically relevant difference}

\item{alpha}{value of nominal size of test}

\item{type}{type of minimum solution (See details)}
}
\value{
vector of solutions for n1 with name vector equal to range of n0
values
}
\description{
This function calls n1.get.vector, runs if for all values of p0 within the
supplied range and then takes the worst (i.e. largest) solution for n1
}
\examples{

# Load toy version of power library for alpha=0.025, delta=0.20.
rdata_file = system.file('files', 'LIB.a025.d20.Rdata', package = 'exact.n')
load(rdata_file)
# n0 solutions when p0=0.5
n1.get.solution(LIB.a025.d20,beta=.7,p0=0.5,delta=0.2,alpha=0.025,type=1)
# n0 solutions for p0 between 0.4 ad 0.5
n1.get.solution(LIB.a025.d20,beta=.7,p0=c(0.4,0.5),delta=0.2,alpha=0.025,type=1)


}
\references{
C.J. Lloyd & R. Ripamonti (2021) A comprehensive open-source
library for exact required sample size in binary clinical trials.
Contemporary Clinical Trials 107. \doi{10.1016/j.cct.2021.106491}
}
\author{
Chris J. Lloyd
}
